;--- treeParty v1.0 ( Include File )

;-------------------------------------------------------------------------------------------------------------
;Notce: all media and tree files must reside in the data/tpMedia directory based off your main development directory.
;ie: c:\myGameProj\data\tpMedia
;-------------------------------------------------------------------------------------------------------------

;-------------------------------------------------------------------------------------------------------------
;Contents
;-- tpLoadEngine()																;used befoire all else, this sets the engines dim's
;-- tpLoadTree(filename$, COLLTYPE_geometry)				:used to load a tree into the tpEngine
;-- tpUpdateEngine(tpCam)													:called once per loop, updates the trees ( pass it the game camera )
;-- tpScaleTree(tree, xs#, ys#, zs#)									:used to scale a tpTree, dont use standard blitz Scaleentity command on tpTree's
;-- tpTreeColor(tree, r, g, b)													;if you wish to set tpTree coloring, use this. ( notice: defaults to 255,255,255 if not called)
;-- tpDeleteTree(tree)															:if you wish to correctly remove a tpTree from your map use this call
;-- tpUnloadEngine()															:unloads the entire tpEngine including all trees and resources, call this when map clearing
;-------------------------------------------------------------------------------------------------------------

;-------------------------------------------------------------------------------------------------------------
;Usage
;tpLoadEngine()  ;--- Notice this must be called first
;tree=tpLoadtree(treefilename$, collision type)
;PositionEntity tree, 100,0,50
;tpScaleTree(tree, x#, y#, z# )
;..
;;main loop
;repeat
;tpUpadeEngine(camera)
;updateworld()
;renderworld()
;flip()
;forever
;..
;tpUnloadEngine()
;End
;-------------------------------------------------------------------------------------------------------------

;-------------------------------------------------------------------------------------------------------------
;Notes:
;v1.0 released 
;	- created user definable tree editor 
;   - improved load times as trees no longer load on startup
;   - optimized the cache routines, quads released on Kill()
;-------------------------------------------------------------------------------------------------------------

;-------------------------------------------------------------------------------------------------------------
;( User settings )
Global tpMaxTrees=500  							;-- set this to the max number of trees your map will contain
Global tpLodRange#=0.00	                        ;-- when the tree exeedes this range the billboard model is dispalyed
Global tpMaxRange#=3300  						;-- when the camera exceedes this range the tree is turned off completely
Global tpProngAnimation=True				;-- set to true or false, true allows prong( leaf) animations to occer 
Global tpBranchAnimation=True 			;-- set to true or false, true allows the branches to animate

;force settings
Global tpProngSpeed#=14.0;7.0 ; 3.3						;-- set value for speed at which prongs will animatie
Global tpBranchSpeed#=1.8;0.9 ; 0.3					;-- set value for speed at which branches will animatie
Global tpProngForce#=10.0 ; 7.0						;-- set value for the overall force(distance) the prongs will sway to.
Global tpBranchForce#=3.5 ; 1.7					;-- set valuse for the overall force(distance) the branches will sway to.

;misc prong settings
Global tpProngRandomShading=True	;-- if True, prongs will recieve a mild shade factor to adjust for tiling effects
Global tpProngFullBright=True				;-- If True, prongs willbe set to fullbright replying upon tpTreeColor(tree, r, g, b) for color/lighting  effects.
;-------------------------------------------------------------------------------------------------------------




;-------------------------------------------------------------------------------------------------------------
;(Engine settings, do not change )
Dim tpMasterTreeIndex(0)  					 ;-- master tree listing, blitzID numbers
Dim tpTreeIndex(0)     					   		 ;-- master tree listing, blitzID numbers
Dim tpTreeQuads(0, 0)
Dim tpTreeQuadRndZ(0, 0)
Dim tpSwayIndex(0, 0)							 ;-- stores the sway point joints for fast access
Dim tpSwayForce#(tpMaxTrees, 0)		 ;-- stores the sway force and strength
Dim tpXxX(0, 0)					 					 ;-	- holds master joint divisions
Dim tpProngX#(0, 0)
Dim tpProngY#(0, 0)
Dim tpProngZ#(0, 0)
Dim tpProngRot#(0, 0)
Dim tpProngParent(0, 0)
Global tpProngWindForce# 					 ;-- used to hold the value of the currebt prongwind force
Global tpInEditMode=False                      ;-- used for creation and debugging,  turning ON will slow down the application.
Global tpEngineLoaded=False                ;-- internal holder
Global tpQuadMesh
Global tpAMBRed=255
Global tpAMBGreen=255
Global tpAMBBlue=255
;-------------------------------------------------------------------------------------------------------------




;-------------------------------------------------------------------------------------------------------------
;define types
Type tpTreePool
	Field tpNum ;-- number representing this tree in the pool
	Field status ;-- 0=off/stripped,  1=on
	Field Quad  ; master quad for this entry
	Field coltype ; stores collision type
	Field trunkFilename$, trunkTexture$, prongTexture$, billboardskin$
	Field totQuads, quadSize#
	Field prongDensity
	Field prongdiv#
	Field masterpiv
	Field xs#, ys#, zs#
	Field glob  ;-- dependant or independant
	Field randZ, loaded
	Field r, g, b
	Field bill ;-- billboard flag
	Field bill_skin ;--billboard texture
End Type

Type tpTrunkMeshCache  ;-- stores all the trunk mesh entities
	Field name$
	Field mesh
End Type

Type tpBarkCache  ;-- stores all the bark textures loaded
	Field name$
	Field texture	
End Type

Type tpProngCache  ;-- stores all the leaf textures loaded
	Field name$
	Field texture	
End Type

Type tpBillBoardCache  ;-- stores the billboard textures 
	Field name$
	Field texture	
End Type

Type tpRepick
	Field st$
End Type

;-- split string function ( blitz code archives )
Type StringArray
    Field Value$
    Field FirstElement.StringArray
    Field NextElement.StringArray
    Field PrevElement.StringArray
    Field Count%
End Type
;--------------------------------------------------------------------------------------------------------------------





;-------------------------------------------------------------------------------------------------------------
;The Functions 

;(User call)  - This must be called before any other tree functions
; use tpUnloadEngine to free all resources from mem.
Function tpLoadEngine()
	
	If tpLodRange>=tpMaxRange Then RuntimeError "'tpLodRange'  must be lessr than 'tpMaxRange'  "
	
	Dim tpMasterTreeIndex(tpMaxTrees)  	 ;-- master tree listing, blitzID numbers
	Dim tpTreeIndex(tpMaxTrees)        		 ;-- master tree listing, blitzID numbers
	Dim tpTreeQuads(tpMaxTrees, 150)
	Dim tpTreeQuadRndZ(tpMaxTrees, 150)
	Dim tpSwayIndex(tpMaxTrees, 10)			 ;-- stores the sway point joints for fast access
	Dim tpSwayForce#(tpMaxTrees, 10)		 ;-- stores the sway force and strength
	Dim tpXxX(tpMaxTrees, 150)					 ;-- holds master joint divisions
	Dim tpProngX#(tpMaxTrees, 250)
	Dim tpProngY#(tpMaxTrees, 250)
	Dim tpProngZ#(tpMaxTrees, 250)
	Dim tpProngRot#(tpMaxTrees, 250)
	Dim tpProngParent(tpMaxTrees, 250)
    tpAMBRed=255
	tpAMBGreen=255
	tpAMBBlue=255

	;-- flag the engine as ON
	tpEngineLoaded=True
	
	;cache pool
	tpQuadMesh=LoadMesh("data\tpMedia\billboards\quad.b3d") : HideEntity tpQuadMesh
	
End Function


;(User call)  - Create a tree - call this function to build a tree.
; passed - tree dat filename, collision type (const)
Function tpLoadTree(filename$, COLLTYPE_geometry)
	Local tptrunkmeshfilename$, tptrunkskinfilename$, tpprongskinfilename$
	Local prongdensity, prongdiv#, prongscale#
	Local temptree, tpTrash#
	
	If tpEngineLoaded=False Then RuntimeError "tpError - call tpLoadEngine() before using the engine functions." 
	
	If filename$="" Then Return
	filename$=tpGetFilename(filename$)
	If FileType("data\tpMedia\"+filename$)=0 Then RuntimeError "tpError - tree file dosen't exist  -  data/tpMedia/"+filename$ : End
	f=ReadFile("data\tpMedia\"+filename$)
		trunkmeshfilename$=ReadString(f)
		trunkskinfilename$=ReadString(f)
		prongskinfilename$=ReadString(f)
		prongdensity=ReadInt(f)
		prongscale#=ReadFloat(f)
		prongdiv#=ReadFloat(f)
		globalized=ReadInt(f)
		tpRandZ=ReadInt(f)
		tpTrash#=ReadFloat(f)
		tpTrash#=ReadFloat(f)
		tpTrash#=ReadFloat(f)
		tpTrash#=ReadFloat(f)
		tpTrash#=ReadFloat(f)
	;-- parse saved quads
	While Not Eof(f)
		st$=ReadLine(f)
		tpS.StringArray = Split(st$,"|")
			;-- find next tree index
			For t=1 To tpMaxTrees
				If tpMasterTreeIndex(t)=0 Then  Exit
			Next
			If t>tpMaxTrees Then RuntimeError "tpError - Max trees exceeded, increase the limit."
			treeNum=t
			;- quad number
			tpa$=sa_Get(tpS, 1)
			tpa$=Right(tpa$, Len(tpa$)-1)
			tpQuad=Int(tpa$)
			; quad x
			tpa$=sa_Get(tpS, 2)
			tpProngX#(treeNum, tpQuad)=Float(tpa$)
			; quad y
			tpa$=sa_Get(tpS, 3)
			tpProngY#(treeNum, tpQuad)=Float(tpa$)
			; quad z
			tpa$=sa_Get(tpS, 4)
			tpProngZ#(treeNum, tpQuad)=Float(tpa$)
			; quad rot
			tpa$=sa_Get(tpS, 5)
			tpProngRot#(treeNum, tpQuad)=Float(tpa$)
			; quad parent
			tpa$=sa_Get(tpS, 6)
			tpa$=Right(tpa$, Len(tpa$)-1)
			tpProngParent(treeNum, tpQuad)=Int(tpa$)
		Delete tpS
	Wend
	CloseFile f
			
	billboardname$=Mid(filename$, 1, Len(filename$)-2)+"png";"bmp"


	;--- load tree
	temptree=tpCTree("data\tpMedia\"+trunkmeshfilename$, "data\tpMedia\"+trunkskinfilename$, "data\tpMedia\"+prongskinfilename$, prongscale#, prongdensity,  prongdiv#, COLLTYPE_geometry, globalized, tpRandZ, 1, billboardname$)
	Return temptree
	
End Function



;(IMPORTANT User call)
;Main Engine Call  - call this function once per loop
Function tpUpdateEngine(tpCam)
Local dist#, mesh, t, aa
	

	;-- prong animation
	tpProngWindForce#=(tpProngWindForce#+tpProngSpeed#)Mod 360

	
	For tp.tpTreePool=Each tpTreePool
		mesh=tpMasterTreeIndex(tp\tpNum)
		dist=EntityDistance(tpCam, mesh)
		
		
		;-- if billboard is ON, spin the bill to match the cam view
		If tp\bill=True Then
			RotateEntity tpTreeIndex(tp\tpNum), 0,EntityYaw(tpCam,1)-180,0
			If tpBranchAnimation=True  tpWindAnim(tpBranchForce#, tpBranchSpeed#*4 , tpTreeIndex(tp\tpNum), tp\tpNum, 0,  EntityYaw(tpTreeIndex(tp\tpNum)))
			
			;-- if lod range has exceeded (kill billboard)
			If dist>tpMaxRange
					FreeEntity tpTreeIndex(tp\tpNum)
					tpTreeIndex(tp\tpNum)=CreatePivot(tpMasterTreeIndex(tp\tpNum))
					PositionEntity tpTreeIndex(tp\tpNum), EntityX(tpMasterTreeIndex(tp\tpNum)), EntityY(tpMasterTreeIndex(tp\tpNum)), EntityZ(tpMasterTreeIndex(tp\tpNum))
					tp\bill=False
					HideEntity tpTreeIndex(tp\tpNum)
			EndIf
			
		EndIf
		
		
		
		
		
		;-- if tree is turned OFF
		If tp\status=0

			;--- if billboard is off then chk range
			If dist<tpMaxRange And dist>tpLodRange And tp\bill=False Then
					FreeEntity tpTreeIndex(tp\tpNum)
					tpTreeIndex(tp\tpNum)=CopyEntity(tpQuadMesh) ;LoadMesh("data/tpMedia\billboards\quad.b3d");  (tpMasterTreeIndex(tp\tpNum))
				    If tp\billboardskin$<>"" Then EntityTexture tpTreeIndex(tp\tpNum) ,  tpLObbCache(tp\billboardskin$)
					;-- finalize
					PositionEntity tpTreeIndex(tp\tpNum), EntityX(tpMasterTreeIndex(tp\tpNum)), EntityY(tpMasterTreeIndex(tp\tpNum)), EntityZ(tpMasterTreeIndex(tp\tpNum))
					ScaleEntity tpTreeIndex(tp\tpNum), tp\xs, tp\ys ,tp\zs
					EntityColor tpTreeIndex(tp\tpNum), tp\r, tp\g, tp\b
					If tpProngRandomShading=True  Then rr=Rand(1,55): EntityColor tpTreeIndex(tp\tpNum),  tp\r-rr, tp\g-rr, tp\b-rr  Else rr=0
					If tpProngFullBright Then EntityFX tpTreeIndex(tp\tpNum), 1
					tp\bill=True
			EndIf
	
			If dist<tpLodRange Then 
				tp\status=1
				tp\bill=False
				tpFlipOn(tp.tpTreePool)
			EndIf
		
		
		Else
		
		
		;-- if tree is ON
			
			;-- line quads to cam
			If EntityInView(tpTreeIndex(tp\tpNum), tpCam)
				
				
				;--- branch animations
				If tpBranchAnimation=True
					tpWindAnim(tpBranchForce#, tpBranchSpeed# , tpTreeIndex(tp\tpNum), tp\tpNum, 0,  EntityYaw(tpTreeIndex(tp\tpNum))) 	 ;-- master tree
					For t=1 To 10
						If  tpSwayIndex(tp\tpNum, t) Then
							tpWindAnim(tpBranchForce#*3, tpBranchSpeed#*3 , tpSwayIndex(tp\tpNum, t)  , tp\tpNum,  t,  EntityYaw(tpSwayIndex(tp\tpNum, t)))
						Else
							Exit
						EndIf
					Next
				EndIf
		
		
		
				;-- face up the quads
				
				If tp\glob=0 Then ;----- globalized
				For t=1 To tp\totQuads
					;quad anim
					If tpProngAnimation=True Then
					If  tpXxX(tp\tpnum,t)=1
						PointEntity tpTreeQuads(tp\tpNum, t), tpCam
						x#=EntityX(tpTreeQuads(tp\tpnum,t))
						z#=EntityZ(tpTreeQuads(tp\tpnum,t))
						yaw#=EntityYaw(tpTreeQuads(tp\tpnum,t))
						TurnEntity tpTreeQuads(tp\tpnum,t), Sin( tpProngWindForce#+x+yaw#)*tpProngForce#,0,Cos( tpProngWindForce#+z+yaw#)*(tpProngForce#/2)+tpTreeQuadRndZ(tp\tpNum, t),0
					EndIf
					Else
					;no quad anim
						PointEntity tpTreeQuads(tp\tpNum, t), tpCam 
						TurnEntity tpTreeQuads(tp\tpNum, t), 0,0,tpTreeQuadRndZ(tp\tpNum, t)
					EndIf
				Next
				
				Else
				
				For t=1 To tp\totQuads  ;-- normal local
					;quad anim
					If tpProngAnimation=True Then
						PointEntity tpTreeQuads(tp\tpNum, t), tpCam
						x#=EntityX(tpTreeQuads(tp\tpnum,t))
						z#=EntityZ(tpTreeQuads(tp\tpnum,t))
						yaw#=EntityYaw(tpTreeQuads(tp\tpnum,t))
						TurnEntity tpTreeQuads(tp\tpnum,t), Sin( tpProngWindForce#+x+yaw#)*tpProngForce#,0,Cos( tpProngWindForce#+z+yaw#)*(tpProngForce#/2)+tpTreeQuadRndZ(tp\tpNum, t),0
					Else
					;no quad anim
						PointEntity tpTreeQuads(tp\tpNum, t), tpCam 
					EndIf
				Next				
				EndIf
				
				
			EndIf
			
			
			;--- clip tree if out of range
			If dist>tpLodRange Then
					tp\status=0
					tpFlipOFF(tp.tpTreePool)
			EndIf
		


		EndIf
	
	Next
	
	
End Function


;(User call)  - Scale a tree - call this function to scale a tree.
;Dont use ScaleEntity() or ScaleMesh() on the trees
Function tpScaleTree(tree, xs#, ys#, zs#)

	cnt=1
	For tp.tpTreePool=Each tpTreePool
		If tree=tp\masterpiv Then
			tp\xs=xs
			tp\ys=ys
			tp\zs=zs
			If tp\status=1 Then ScaleEntity tpTreeIndex(tp\tpNum), tp\xs, tp\ys ,tp\zs
			Exit
		EndIf
		cnt=cnt+1
	Next
	
End Function



;(User call)  - Deletes a tree - call this function to remove a tree.
Function tpDeleteTree(tree)

	For tp.tpTreePool=Each tpTreePool
	  
	  If tree=tp\masterpiv Then
	  	
 		For t=1 To tp\totQuads :	 tpTreeQuadRndZ(tp\tpNum, t)=0 : Next
 		For t=1 To 250 :  tpProngX#(tp\tpNum, t)=0 : Next
		For t=1 To 250 : 	tpProngY#(tp\tpnum, t)=0 : Next
		For t=1 To 250 :  tpProngZ#(tp\tpnum, t)=0 : Next
		For t=1 To 250 : 	tpProngRot#(tp\tpnum,t)=0 : Next
		For t=1 To 250 :  tpProngRot#(tp\tpnum, t)=0 : Next
		For t=1 To 10  :  tpSwayIndex(tp\tpnum, t)=0 : Next

  	
	  	If tp\status=1 Then tpFlipOFF(tp.tpTreePool)
   		FreeEntity tpTreeIndex(tp\tpNum)
  		FreeEntity tree
  		tpTreeIndex(tp\tpNum)=0
  		tpMasterTreeIndex(tp\tpNum)=0
  		Delete tp
		Return
	  	
	  EndIf
	
	Next


End Function



;(User call)  - unloads all trees and resets all variable.
;call this engine to remove all instances of trees.
Function tpUnloadEngine()

	;kill each tree
	For tp.tpTreePool=Each tpTreePool
		 tpDeleteTree(tp\masterpiv)
	Next

	;redim the slot holders
	Dim tpMasterTreeIndex(0)  	 ;-- master tree listing, blitzID numbers
	Dim tpTreeIndex(0)        		 ;-- master tree listing, blitzID numbers
	Dim tpTreeQuads(0, 0)
	Dim tpTreeQuadRndZ(0, 0)
	Dim tpSwayIndex(0, 0)			 ;-- stores the sway point joints for fast access
	Dim tpSwayForce#(tpMaxTrees, 0)		 ;-- stores the sway force and strength
	Dim tpXxX(0, 0)					 ;-- holds master joint divisions
	Dim tpProngX#(0, 0)
	Dim tpProngY#(0, 0)
	Dim tpProngZ#(0, 0)
	Dim tpProngRot#(0, 0)
	Dim tpProngParent(0, 0)
	
	;-- make sure all entires are gone
	For tp.tpTreePool=Each tpTreePool
		 Delete tp
	Next


	;-- unload caches
 	For tpBb.tpBillBoardCache=Each tpBillBoardCache  ;-- stores the billboard textures 
		FreeTexture tpBb\texture
		Delete tpBb
	Next
	For tpPc.tpProngCache=Each tpProngCache
		FreeTexture tpPc\texture
		Delete tpPc
	Next
	For tpBc.tpBarkCache=Each tpBarkCache
		FreeTexture tpBc\texture
		Delete tpBc
	Next
	For tpTm.tpTrunkMeshCache=Each tpTrunkMeshCache
		FreeEntity  tpTm\mesh
		Delete tpTm
	Next


 	;-- flag the engine as OFF
 	tpEngineLoaded=False

End Function



;(User call)  - sets a tpTrees entity color ( defaults to 255,255,255)
Function tpTreeColor(tree, r, g, b)


	For tp.tpTreePool=Each tpTreePool
	  
	  If tree=tp\masterpiv Then
		
		;set the rgb for reference
		tp\r=r
		tp\g=g
		tp\b=b
	  		
	  		
		;-- if tree is turned on
	  	If tp\status=1 Then
			
			;color the trunk mesh
  			EntityColor tpTreeIndex(tp\tpNum), tp\r, tp\g, tp\b

		  	;color the quads
	  		For t=1 To tp\totQuads
					EntityColor  tpTreeQuads(tp\tpNum, t), tp\r, tp\b, tp\g
			Next
		EndIf

		Return	  	
	  EndIf
	
	Next
	
End Function



Function tpAmbient(r, g, b)
Local HighR, HighG, HighB
Local LowR, LowG, LowB
tpAMBRed=r : tpAmbGREEN=g : tpAMBBlue=b
HighR=r+100 : If HighR>255 Then HighR=255
HighG=r+100 : If HighG>255 Then HighG=255
HighB=r+100 : If HighB>255 Then HighB=255
LowR=r-100 : If LowR<0 Then LowR=0
LowG=r-100 : If LowG<0 Then LowG=0
LowB=r-100 : If LowB<0 Then LowB=0

	For tp.tptreepool=Each tptreepool
		If tp\status=True
			EntityColor tpTreeIndex(tp\tpNum), tpAMBRed, tpAMBGreen, tpAMBBlue

			For t=1 To tp\totQuads
				tpSurface=GetSurface(tpTreeQuads(tp\tpNum, t),1)
				VertexColor tpsurface, 0,HighR, HighG, HighB
				VertexColor tpsurface, 1, r,g,b
				VertexColor tpsurface, 2,r, g, b
				VertexColor tpsurface, 3,LowR, LowG, LowB
				Exit
			Next

		EndIf
	Next
End Function









;No need to call anything below this line, its for internal use only
;-------------------------------------------------------------------------------------------------------------------------------------------------------------------------


;-- Internal loader, don't call this - use tpLoadTree(filename$) instead
;	trunk_filename$ = path + file to the trunk mesh to be used.
;	trunktexture_filename$ = path + file to the trunk texture to be used.
;	prongtexture_filename$ = path + file to the leaf texture to be used.
;	collision type = your defined collision type for the trunk of this mesh.
;(( this is used by the editor during tree creation ))
Function tpCTree(trunk_filename$, trunktexture_filename$, prongtexture_filename$, quadsize#=3.0 , prongDensity,  prongdiv#,  collision_type, globalized, randZ, loaded, billboardname$="")
	Local tpTree, t, r
	If trunk_filename$="" Or prongtexture_filename$=""  Or trunktexture_filename$="" Then RuntimeError "tpError - Invalid settings sent to tpCreateTree()"
	If FileType(trunk_filename$)=0 Then RuntimeError  "tpError - Trunk not found:  "+trunk_filename$
	If FileType(trunktexture_filename$)=0 Then RuntimeError  "tpError - Trunk texture not found:  "+trunktexture_filename$
	If FileType(prongtexture_filename$)=0 Then RuntimeError  "tpError - Prong texture not found:  "+prongtexture_filename$
	If prongDensity<0 Or prongDensity>4 Then RuntimeError "tpError - Invalid prong density ."


	;-- find next tree index
	For t=1 To tpMaxTrees
		If tpMasterTreeIndex(t)=0 Then  Exit
	Next
	If t>tpMaxTrees Then RuntimeError "tpError - Max trees exceeded, increase the limit."
	
	
	;-- make master index
 	tpMasterTreeIndex(t)=CreatePivot()
 	HideEntity tpMasterTreeIndex(t)
 	
	
	;-- make a placeholder
	tpTreeIndex(t)=CreatePivot(tpMasterTreeIndex(t))
	HideEntity tpTreeIndex(t)
	
	
	;-- make sure tree texture  is in cache
	tpTrash=tpLOBarkCache(trunktexture_filename$)


	;-- make sure the prong/leaf texture is in the cache
	tpTrash=tpLOProngCache(prongtexture_filename$)
	

	
	;-- create a pool entry for this tree
	tpTP. tpTreePool=New tpTreePool
	tpTP\tpNum=t 
	tpTP\status=0  ;-- off by default
	tpTP\coltype=collision_type
	tpTP\trunkfilename$=trunk_filename$
	tpTP\trunktexture$=trunktexture_filename$
	tpTP\prongtexture$=prongtexture_filename$
	tpTP\quadSize#=quadsize
	tpTP\prongDensity=prongDensity
	tpTP\prongdiv#=prongdiv#
	tpTP\Masterpiv=tpMasterTreeIndex(t)
	tpTP\xs#=1
	tpTP\ys#=1
	tpTP\zs#=1
	tpTP\glob=globalized
	tpTP\randZ=randZ
	tpTP\loaded=loaded
	tpTP\r=255
	tpTP\g=255
	tpTP\b=255
	tpTP\billboardskin$=billboardname$
	
	Return tpMasterTreeIndex(t)
End Function




;(Internal, no need to call)
;this function looks up the cached bark textures 
Function tpLOBarkCache(trunktexture_filename$)
	;local lookupname$=tpGetFilename$(trunktexture_filename$)
	
	For tpBC.tpBarkCache=Each tpBarkCache
		If tpBC\name$=trunktexture_filename$ Then Return tpBC\texture
	Next
	
	;-- texture not found, load it
	tpBC.tpBarkCache=New tpBarkCache
	tpBC\texture=LoadTexture(trunktexture_filename$)
	tpBC\name$=trunktexture_filename$
	Return tpBC\texture
		
End Function




;(Internal, no need to call)
;used by the tp engine to cach trunks ( faster than accessing drive )
Function tpLOTrunkMeshCache(trunk_filename$)

	For tpTm.tpTrunkMeshCache=Each tpTrunkMeshCache
		If tpTm\name$=trunk_filename$ Then Return tpTm\Mesh
	Next

	;-- mesh not found, load it
	tptm.tpTrunkMeshCache=New tpTrunkMeshCache
	tptm\mesh=LoadAnimMesh(trunk_filename$)
	HideEntity tptm\mesh
	tptm\name$=trunk_filename$
    UpdateNormals tptm\mesh
	Return tptm\mesh
		
		
End Function




;(Internal, no need to call)
;used by the tp engine to gather filenames
Function tpGetFilename$(tp_tempfilename$) ; Returns the filename and extension
	Local a$, i
	Local lastdir = 1
	Local filename$=tp_tempfilename$
	For i=1 To Len(filename$)
		If Mid$(filename$,i,1) = "\" Then Lastdir = i
	Next
	If Lastdir > 1 Then Lastdir = Lastdir + 1
	For i=Lastdir To Len(filename$)
		a$ = a$ + Mid(filename$,i,1)
	Next
	Return a$
End Function





;(Internal, no need to call)
;creates and returns a quad
Function tpMakeaQuad()
	Local tpMesh,  tpSurf
	
	tpMesh 			= CreateMesh()
	tpSurface 		= CreateSurface(tpMesh)
	
	AddVertex   tpSurface, -1, 1, 0, 0, 0
	AddVertex   tpSurface,  1, 1, 0, 1, 0
	AddVertex   tpSurface, -1,-1, 0, 0, 1
	AddVertex   tpSurface,  1,-1, 0, 1, 1
		
	AddTriangle tpSurface, 0, 1, 2
	AddTriangle tpSurface, 3, 2, 1
	FlipMesh tpMesh
	EntityFX tpMesh, 1+2
	
	Return tpMesh
	
End Function





;(Internal, no need to call)
;loads and returns a prong/leaf texture from the cache pool
Function tpLOProngCache(prongtexture_filename$)

	For tpPC.tpProngCache=Each tpProngCache
		If tpPC\name$=prongtexture_filename$ Then Return tpPC\texture
	Next

	;-- texture not found, load it
	tpPC.tpProngCache=New tpProngCache
	tpPC\texture=LoadTexture(prongtexture_filename$, 2)
	tpPC\name$=prongtexture_filename$
	Return tpPC\texture

End Function




;(Internal, no need to call)
;loads and returns a billboard texture from the cache pool
Function tpLObbCache(filename$)

	For tpbb.tpBillboardCache=Each tpBillboardCache
		If tpbb\name$=filename$ Then Return tpbb\texture
	Next

	;-- texture not found, load it
	tpbb.tpBillboardCache=New tpBillboardCache
	If FileType("data\tpMedia\billboards\"+filename$)=0 Then RuntimeError "Unable to locate billboard texture file:   "+"data\tpMedia\billboards\"+filename$
	tpbb\texture=LoadTexture("data\tpMedia\billboards\"+filename$, 4)
	tpbb\name$=filename$
	Return tpbb\texture

End Function





;(Internal, no need to call)
;turns off a tree
Function tpFlipOFF(tp.tpTreePool)
Local t

	hx#=EntityX(tpMasterTreeIndex(tp\tpNum))
	hy#=EntityY(tpMasterTreeIndex(tp\tpNum))
	hz#=EntityZ(tpMasterTreeIndex(tp\tpNum))
	hpitch#=EntityPitch(tpMasterTreeIndex(tp\tpNum))
	hyaw#=EntityYaw(tpMasterTreeIndex(tp\tpNum))
	hroll#=EntityRoll(tpMasterTreeIndex(tp\tpNum))
	
	
	;-- remove attached quads
	For t=1 To tp\totQuads :  tpXxX(tp\tpNum,t)=0  : Next
	For t=1 To tp\totQuads :  EntityParent	tpTreeQuads(tp\tpNum, t), 0 : 	Next
	For t=1 To tp\totQuads
		FreeEntity  tpTreeQuads(tp\tpNum, t)
		tpTreeQuads(tp\tpNum, t)=0
	Next


	;-- delete the entire tree
	FreeEntity tpTreeIndex(tp\tpNum)

	
	;-- delete master quad
	FreeEntity tp\Quad
	tp\Quad=0


	;-- insert billboard
	;tpTreeIndex(tp\tpNum)=CreatePivot(tpMasterTreeIndex(tp\tpNum))
	;tpTreeIndex(tp\tpNum)=LoadMesh("data\tpMedia\billboards\quad.b3d");  (tpMasterTreeIndex(tp\tpNum))
	tpTreeIndex(tp\tpNum)=CopyEntity(tpQuadMesh);  (tpMasterTreeIndex(tp\tpNum))
	
	;-- finalize
	PositionEntity tpTreeIndex(tp\tpNum), hx, hy, hz
	ScaleEntity tpTreeIndex(tp\tpNum), tp\xs, tp\ys ,tp\zs
	EntityColor tpTreeIndex(tp\tpNum), tp\r, tp\g, tp\b
	If tpProngRandomShading=True  Then rr=Rand(1,55): EntityColor tpTreeIndex(tp\tpNum), tp\r-rr, tp\g-rr, tp\b-rr  Else rr=0
	If tpProngFullBright Then EntityFX tpTreeIndex(tp\tpNum), 1
    If tp\billboardskin$<>"" Then EntityTexture tpTreeIndex(tp\tpNum) ,  tpLObbCache(tp\billboardskin$)
	tp\bill=True
	;HideEntity tpTreeIndex(tp\tpNum)

End Function





;(Internal, no need to call)
;turns a tree entity ON and makes it ready for use
Function 	tpFlipOn(tp.tpTreePool)
	Local tpChild, hx#, hy#, hz#, hpitch#, hyaw#, hroll#, t, qcnt, ch, tt
	Local ux#, uy#, uz#, rr
	Local tpPass

		
	hx#=EntityX(tpMasterTreeIndex(tp\tpNum))
	hy#=EntityY(tpMasterTreeIndex(tp\tpNum))
	hz#=EntityZ(tpMasterTreeIndex(tp\tpNum))
	hpitch#=EntityPitch(tpTreeIndex(tp\tpNum))
	hyaw#=EntityYaw(tpMasterTreeIndex(tp\tpNum))
	hroll#=EntityRoll(tpMasterTreeIndex(tp\tpNum))


	
	;-- kill the placeholder
	FreeEntity tpTreeIndex(tp\tpNum)



	;load trunk mesh
	tpTreeIndex(tp\tpNum)=CopyEntity(tpLOTrunkMeshCache(tp\trunkfilename$)); copyentity(tp\trunkfilename$);LoadAnimMesh(tp\trunkfilename$)
	EntityColor tpTreeIndex(tp\tpNum), tpAMBRed, tpAMBGreen, tpAMBBlue
	EntityFX  tpTreeIndex(tp\tpNum), 1
		
		
	;-- texture the trunk with cache
	EntityTexture tpTreeIndex(tp\tpNum), tpLOBarkCache(tp\trunktexture$)
	
	
	
	;-- setup tree trunk collision
	EntityType tpTreeIndex(tp\tpNum), tp\coltype



	;-- record the sway points on the tree to be used for animation
	For r=1 To 10
		tpChild=FindChild( tpTreeIndex(tp\tpNum), "mSway"+r) 
		If tpChild=0 Then Exit
		tpSwayIndex(tp\tpNum,r)=tpChild
	Next

	

	;-- make master Quad
	tp\Quad=tpMakeaQuad()
	UpdateNormals tp\Quad
	HideEntity tp\Quad
	
	HighR=tpAMBRed+100 : If HighR>255 Then HighR=255
	HighG=tpAMBgreen+100 : If HighG>255 Then HighG=255
	HighB=tpAMBBlue+100 : If HighB>255 Then HighB=255
	LowR=tpAMBRed-100 : If LowR<0 Then LowR=0
	LowG=tpAMBRed-100 : If LowG<0 Then LowG=0
	LowB=tpAMBRed-100 : If LowB<0 Then LowB=0
	tpsurface=GetSurface(tp\quad,1)
	VertexColor tpsurface, 0,HighR, HighG, HighB
	VertexColor tpsurface, 1, tpAMBRed, tpAMBGreen, tpAMBBlue
	VertexColor tpsurface, 2,tpAMBRed, tpAMBGreen, tpAMBBlue
	VertexColor tpsurface, 3,LowR, LowG, LowB

	
	;-- distribute the quads
	qcnt=1
	SeedRnd MilliSecs()
	For t=1 To 50
		ch=FindChild( tpTreeIndex(tp\tpNum), "prong"+t)
			If ch>0 Then
				tpTreeQuads(tp\tpNum, qcnt) = CopyEntity(tp\Quad)

				EntityTexture tpTreeQuads(tp\tpNum, qcnt) , tpLOProngCache(tp\prongtexture$)
				;If tpProngRandomShading Then rr=Rand(1,50) Else rr=0 
				EntityColor tpTreeQuads(tp\tpNum, qcnt), tp\r-rr, tp\g-rr, tp\b-rr
			;	If tpProngFullBright Then EntityFX tpTreeQuads(tp\tpNum, qcnt), 1
				tpXxX(tp\tpnum,qcnt)=1 :tpHold=qcnt

				;-- add aditional prongs if settings call for it
					For tt=1 To tp\prongDensity
						qcnt=qcnt+1 
						tpTreeQuads(tp\tpNum, qcnt) = CopyEntity(tp\Quad)
						EntityTexture tpTreeQuads(tp\tpNum, qcnt) , tpLOProngCache(tp\prongtexture$)
					;	If tpProngRandomShading=True  Then rr=Rand(1,55) Else rr=0
						EntityColor tpTreeQuads(tp\tpNum, qcnt), tp\r-rr, tp\g-rr, tp\b-rr
					;	If tpProngFullBright Then EntityFX tpTreeQuads(tp\tpNum, qcnt), 1

						
						
If tp\loaded=0				
						
						If tp\glob=1 Then 
						    PositionEntity tpTreeQuads(tp\tpNum, qcnt)  ,  EntityX(ch,1), EntityY(ch,1), EntityZ(ch,1)
							ScaleEntity tpTreeQuads(tp\tpNum, qcnt), tp\quadSize, tp\quadSize, tp\quadSize
					   EndIf

						.repick
						div#=2.0
						Select tt
								Case 1
									If Rand(1,2)=1 Then gh1#=-(tp\quadSize/div)-tp\prongdiv Else gh1=( tp\quadSize/div)+tp\prongdiv
									If Rand(1,2)=1 Then gh2#=-(tp\quadSize/div)-tp\prongdiv Else gh2=( tp\quadSize/div)+tp\prongdiv
									If Rand(1,2)=1 Then gh3#=-(tp\quadSize/div)-tp\prongdiv Else gh3=( tp\quadSize/div)+tp\prongdiv
								
								Case 2 
									If Rand(1,2)=1 Then gh1#=-(tp\quadSize/div)-tp\prongdiv Else gh1=( tp\quadSize/div)+tp\prongdiv
									If Rand(1,2)=1 Then gh2#=-(tp\quadSize/div)-tp\prongdiv Else gh2=( tp\quadSize/div)+tp\prongdiv
									If Rand(1,2)=1 Then gh3#=-(tp\quadSize/div)-tp\prongdiv Else gh3=( tp\quadSize/div)+tp\prongdiv
								
								Case 3
									If Rand(1,2)=1 Then gh1#=-(tp\quadSize/div)-tp\prongdiv Else gh1=( tp\quadSize/div)+tp\prongdiv
									If Rand(1,2)=1 Then gh2#=-(tp\quadSize/div)-tp\prongdiv Else gh2=( tp\quadSize/div)+tp\prongdiv
									If Rand(1,2)=1 Then gh3#=-(tp\quadSize/div)-tp\prongdiv Else gh3=( tp\quadSize/div)+tp\prongdiv

								Case 4
									If Rand(1,2)=1 Then gh1#=-(tp\quadSize/div)-tp\prongdiv Else gh1=( tp\quadSize/div)+tp\prongdiv
									If Rand(1,2)=1 Then gh2#=-(tp\quadSize/div)-tp\prongdiv Else gh2=( tp\quadSize/div)+tp\prongdiv
									If Rand(1,2)=1 Then gh3#=-(tp\quadSize/div)-tp\prongdiv Else gh3=( tp\quadSize/div)+tp\prongdiv

						End Select
						
						;-- add it to the 'already used positions'
						tst$=gh1+" "+gh2+" "+gh3
						For re.tprepick=Each tprepick
							If re\st$=tst$ Then  Goto repick
						Next
												
						;put the quad into place
						If tp\glob=0 : gh1=gh1/1.5 : gh2=gh2/1.5 : 	gh3=gh3/1.5 : 	EndIf
						MoveEntity tpTreeQuads(tp\tpNum, qcnt), gh1, gh2, gh3
						re.tprepick=New tprepick : 	re\st$=gh1+" "+gh2+" "+gh3
											    
					    ;-- randomZ turns
					    If tp\randZ Then 
					    	tpTreeQuadRndZ(tp\tpNum, qcnt)=Rand(-180,180)  ;-- random set rotation
							TurnEntity tpTreeQuads(tp\tpNum, qcnt),  0, 0,tpTreeQuadRndZ(tp\tpNum, qcnt),1
						EndIf
						
  						If tp\glob=0 Then par=tphold Else par=0
  						If tpInEditMode=True tpWrite("Q"+qcnt+"|"+EntityX(tpTreeQuads(tp\tpNum, qcnt),1)+"|"+EntityY(tpTreeQuads(tp\tpNum, qcnt),1)+"|"+EntityZ(tpTreeQuads(tp\tpNum, qcnt),1)+"|"+EntityRoll(tpTreeQuads(tp\tpNum, qcnt),1)+"|p"+par)

						
						;-- parent the quads based on global or local setting
						If tp\glob=0 Then
						   EntityParent tpTreeQuads(tp\tpNum, qcnt), tpTreeQuads(tp\tpNum, tphold),1
						Else
							EntityParent tpTreeQuads(tp\tpNum, qcnt), ch,1
						EndIf


Else ;-- loaded quad ( pre-stored)
	
	 PositionEntity tpTreeQuads(tp\tpNum, qcnt), tpProngX#(tp\tpNum, qcnt),tpProngY#(tp\tpNum, qcnt), tpProngZ#(tp\tpNum, qcnt)
	 TurnEntity tpTreeQuads(tp\tpNum, qcnt),  0, 0,tpProngRot#(tp\tpNum, qcnt),1
	  If tpProngParent(tp\tpNum, qcnt)=0 Then
	 EntityParent tpTreeQuads(tp\tpNum, qcnt), ch, 1
	 ScaleEntity tpTreeQuads(tp\tpNum, qcnt), tp\quadSize, tp\quadSize, tp\quadSize,1
		If tpInEditMode=True Then 
			If tp\glob=0 Then par=tphold Else par=0
			tpWrite("Q"+qcnt+"|"+EntityX(tpTreeQuads(tp\tpNum, qcnt),1)+"|"+EntityY(tpTreeQuads(tp\tpNum, qcnt),1)+"|"+EntityZ(tpTreeQuads(tp\tpNum, qcnt),1)+"|"+EntityRoll(tpTreeQuads(tp\tpNum, qcnt),1)+"|p"+par)
		EndIf


   Else
      EntityParent tpTreeQuads(tp\tpNum, qcnt),  tpTreeQuads(tp\tpNum, tpProngParent(tp\tpNum, qcnt) ),1
	EndIf

EndIf



					Next


					;clear the 'already in position' list
					For re.tprepick=Each tprepick : Delete re : Next
					;-- finalize parent quad
					PositionEntity tpTreeQuads(tp\tpNum, tpHold),  EntityX(ch,1), EntityY(ch,1), EntityZ(ch,1),1 
					If tpInEditMode=True tpWrite( "Q"+tphold+"|"+EntityX(tpTreeQuads(tp\tpNum, tpHold),1)+"|"+EntityY(tpTreeQuads(tp\tpNum, tpHold),1)+"|"+EntityZ(tpTreeQuads(tp\tpNum, tpHold),1)+"|"+EntityRoll(tpTreeQuads(tp\tpNum, tpHold),1)+"|p0")
					ScaleEntity tpTreeQuads(tp\tpNum, tpHold), tp\quadSize, tp\quadSize, tp\quadSize,1
					EntityParent tpTreeQuads(tp\tpNum, tpHold), ch,1

				
				qcnt=qcnt+1  
			EndIf
		
	Next
	tp\totQuads=qcnt-1
	



	;-- finalize
	PositionEntity tpTreeIndex(tp\tpNum), hx, hy, hz
	TurnEntity tpTreeIndex(tp\tpNum), hpitch, hyaw, hroll
	ScaleEntity tpTreeIndex(tp\tpNum), tp\xs, tp\ys ,tp\zs
	FreeEntity tp\Quad : tp\quad=0

End Function





;(Internal, no need to call)
;handles sway animations
Function tpWindAnim(force#, speed#, mesh, meshnum, jointnum, yaw#)

  tpSwayForce(meshnum, jointnum)=(tpSwayForce(meshnum, jointnum)+speed#)Mod 360
  x#=EntityX(mesh)
  z#=EntityZ(mesh)
  RotateEntity mesh,Sin( tpSwayForce(meshnum, jointnum)+x+yaw#)*force#,yaw,Cos( tpSwayForce(meshnum, jointnum)+z+yaw#)*(force#/2)

End Function




;(Internal, no need to call)
;-- used during Editor/creation
Function tpWrite(v$)
	
	If FileType("builder.dat")=0 Then ff=WriteFile( "builder.dat") : CloseFile ff
	ff=ReadFile("builder.dat")
	f=WriteFile("temp.dat")
	
	While Not Eof(ff)
		dd$=ReadLine(ff)
		WriteLine f, dd$
	Wend
	CloseFile ff
	
	WriteLine f, v$

	CloseFile f
	DeleteFile "builder.dat"
	CopyFile "temp.dat", "builder.dat"
	DeleteFile "temp.dat"
	

End Function











;--- blitz code archive functions
Function Split.StringArray(sVal$, sSep$)
    tpS.StringArray = New StringArray
    If sVal = "" Then
        Return tpS
    End If
    While Len(sVal) > 0
        i% = Instr(sVal, sSep)
        If i = 0 Then 
            sa_Append tpS, sVal
            sVal = ""
        Else
            sa_Append tpS, Left(sVal,i-1)
            sVal = Mid(sVal, i+Len(sSep))
        End If
    Wend
    Return tpS
End Function
Function sa_Append(s.StringArray, sVal$)
    If s=Null Then Return
    If s\FirstElement = Null Then
        s\Count = 1
        s\FirstElement = s
        s\Value = sVal
        ;DebugLog "sa_Append, Appended:" + sVal
        Return
    End If
    If s\NextElement = Null
        s\Count = s\Count + 1
        s\NextElement = New StringArray
        s\NextElement\Count = 1
        s\NextElement\PrevElement = s
        s\NextElement\FirstElement= s\FirstElement
        s\NextElement\Value = sVal
        ;DebugLog "sa_Append, Appended:" + sVal
    Else
        s\Count = s\Count + 1
        sa_Append(s\NextElement , sVal)
    End If
End Function
Function sa_Count%(s.StringArray)
    If s = Null Then Return 0
    Return s\FirstElement\Count%
End Function
Function sa_Find.StringArray(s.StringArray, index%)
    If s = Null Then Return Null
    If index < 1 Then Return Null
    If index = 1 Then Return s
    Return sa_Find(s\NextElement, index-1)
End Function
Function sa_Get$(s.StringArray, index%)
    If s = Null Then Return ""
    s = s\FirstElement
    s = sa_Find(s, index)
    If s<>Null Then    Return s\Value
End Function
Function sa_Destroy(s.StringArray)
    If s = Null Then Return
    If s\FirstElement = Null Then
        ;DebugLog "sa_Destroy, Deleted: " + s\Value
        Delete s
        Return
    End If
    If s\NextElement = Null Then
        s = s\PrevElement        
        ;DebugLog "sa_Destroy, Deleted: " + s\NextElement\Value
        Delete s\NextElement
        sa_Destroy s
    Else
        s = s\FirstElement
        s\FirstElement = Null
        sa_Destroy sa_Find(s, s\Count)
    End If
End Function



;
